/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Actor      ground,actor[10];
Controller ctrl            ; // controller - it's meant to be used as a 'character actor'
/******************************************************************************/
void InitPre()
{
   App.name="Physics Controllers";
   App.flag=APP_MS_EXCLUSIVE|APP_NO_FX;
   PakAdd("../data/engine.pak");
   D.sync(true);
}
Bool Init()
{
   Cam    .dist=4;
   Physics.create();
   ground .create(Box(15,1,15,Vec(0,-2,0)), 0);

   // create random actors
   REPA(actor)switch(Rnd(3))
   {
      case 0:actor[i].create(Box    (RndF(0.1,0.5),              Rnd(Box(10,1,10))));break;
      case 1:actor[i].create(Ball   (RndF(0.1,0.5),              Rnd(Box(10,1,10))));break;
      case 2:actor[i].create(Capsule(RndF(0.1,0.2),RndF(0.5,1.0),Rnd(Box(10,1,10))));break;
   }
   
   // create controller
   ctrl.create(Capsule(0.4,1.7));
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button

   Physics.sim().get();

   // update controller (move on WSAD keys, crouch on Shift key, jump on Space key)
   Flt s=3;
   Vec vel(0,0,0);
   if(Kb.b(KB_W))vel+=!PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s;
   if(Kb.b(KB_S))vel-=!PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s;
   if(Kb.b(KB_A))vel-=!PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s;
   if(Kb.b(KB_D))vel+=!PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s;
   ctrl.update(vel, Kb.shift, Kb.bp(KB_SPACE) ? 3.5 : 0);

   return true;
}
/******************************************************************************/
void Draw()
{
   D      .clear();
   Physics.draw ();
}
/******************************************************************************/
